/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.Reference;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.util.ValueOrItemReference;

public class TimeValueProperties
implements ValueOrItemReference {
    protected TimeUnit fCurrentValue;
    protected TimeUnit[] fAvailableTimeUnits;
    private BlockParameter fParameter;

    public TimeValueProperties() {
    }

    public TimeValueProperties(TimeUnit currentTime, TimeUnit[] availableTimeUnits) {
        this.fCurrentValue = currentTime;
        this.fAvailableTimeUnits = availableTimeUnits;
    }

    public TimeUnit getCurrentValue() {
        return this.fCurrentValue;
    }

    public void setCurrentValue(TimeUnit currentValue) {
        this.fCurrentValue = currentValue;
    }

    public void setMinLowValue(int value) {
        this.fCurrentValue.setLowMin(value);
    }

    public TimeUnit[] getAvailableTimeUnits() {
        return this.fAvailableTimeUnits;
    }

    public void setAvailableTimeUnits(TimeUnit[] availableTimeUnits) {
        this.fAvailableTimeUnits = availableTimeUnits;
    }

    public void setReferenceTimeUnit(TimeUnit unit) {
        if (!this.isReference()) {
            return;
        }
        ((Reference)this.getCurrentValue()).setTimeUnit(unit);
    }

    public Object getDefaultDirectValue() {
        TimeUnit[] timeUnits = this.getAvailableTimeUnits();
        return new TimeValueProperties(TimeUnit.getNewTimeObject(timeUnits[timeUnits.length - 1].getUnitKey()), timeUnits);
    }

    public Object setDefaultDirectValue() {
        this.setCurrentValue(((TimeValueProperties)this.getDefaultDirectValue()).getCurrentValue());
        return this;
    }

    public ParameterItem getReference() {
        if (this.isReference()) {
            return ((Reference)this.getCurrentValue()).getReference();
        }
        return null;
    }

    public String toString() {
        return this.fCurrentValue.toString();
    }

    private void convertToReference() {
        if (!this.isReference()) {
            this.fCurrentValue = new Reference();
        }
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
    }

    public boolean isReference() {
        return this.fCurrentValue instanceof Reference;
    }

    public void setParameter(BlockParameter param) {
        this.fParameter = param;
    }

    public void setReference(ParameterItem reference) {
        if (!this.isReference()) {
            this.convertToReference();
        }
        ((Reference)this.getCurrentValue()).setReference(reference);
    }
}

